<!DOCTYPE html>
<html>
  <head>
    <meta charset="utf-8">

    <title>Mes recettes</title>
    <link rel="stylesheet" href="css/style.css">

    <!-- assure la compatibilité des éléments sémantiques avec les anciennes versions d'IE -->
    <!--[if lt IE 9]>
      <script src="https://cdnjs.cloudflare.com/ajax/libs/html5shiv/3.7.3/html5shiv.js"></script>
    <![endif]-->
  </head>

  <body>
    <header>
      <h1>Mes recettes</h1>
    </header>

    <nav>
      <ul>
        <li><a href="index.php">Accueil</a></li>
        <li><a href="recettes/soupepotimarron.php">Soupe de potimaron</a></li>
        <li><a href="recettes/biscuitsnoel.php">Biscuits de Noël</a></li>
        <li><a href="recettes/pancakes.php">Pancakes</a></li>
        <li><a href="tp_instructions.php">Le TP</a></li>
        <li><a href="contact.php">Contact</a></li>
      </ul>
     </nav>

    <main>
      <article>
        <h2>Travaux Pratiques de PHP</h2>

        <p>Vous trouverez ci-dessous les instructions pour faire ce TP.</p>

        <h3 id="partie_1">Partie 1 : Prise en main du site</h3>

        <img class="illustration_tp"
        src="images/lets-go.png"
        alt="Panneau de direction avec écrit start en rouge orné de petites fleurs bleues"/>

        <ol>
          <li><input type="checkbox" checked> <a href="http://flavietonon.online/BTSSIO/tp_php_2.zip">Télécharger le code source du site</a></li>
          <li><input type="checkbox" checked> Copier/coller le projet dans votre dossier htdocs ou www</li>
          <li><input type="checkbox" checked> Regardez le code source du site en l'ouvrant avec l'éditeur de texte de votre choix (atom, phpstorm, visual sutdio, xcode...)</li>
          <li><input type="checkbox" checked> Visualisez le code HTML pour la barre de navigation (élément <code>&ltnav&gt</code>) pour chaque page : remarquez que ce bout de code est presque toujours identique.</li>

          <div class="info">
            <p>Vous l'avez peut-être remarqué, les liens dans la navigation ne sont pas toujours les mêmes !
            Pourquoi ? Car suivant le répertoire dans lequel se trouve la page, le chemin relatif vers la page cible ne sera pas le même, logique !</p>
          </div>

          <li><input type="checkbox"> Nous souhaitons modifier le titre "Soupe de potimaron" en "Soupe de potimarron" partout sur le site. Ce serait dommage de laisser une faute d'orthographe sur notre beau site !</li>
          <ol>
            <li><input type="checkbox"> Modifiez le titre dans la barre de navigation (sur toutes les pages !)</li>
            <li><input type="checkbox"> N'oubliez pas de modifier le h2 de la page soupepotimarron.php</li>
          </ol>
          <li><input type="checkbox"> Modifiez le code de la page <a href=#>tp_instructions.php</a> (celle que vous êtes en train de lire !) au fur et à mesure que vous validez les étapes. Ajoutez l'attribut "checked" dans l'élément input à côté des tâches que vous avez effectuées. Regardez, j'ai déjà validé pour vous l'étape 1 ;).</li>

        </ol>

        <h3 id="partie_2">Partie 2 : Un code modulaire</h3>

          <img class="illustration_tp"
                src="images/module.png"
                alt="Formes géométriques"/>
          <ol>
            <li><input type="checkbox"> Créez un fichier <a href="footer.php">footer.php</a> à la racine de votre projet.</li>
            <li><input type="checkbox"> Ouvrez le code source de <a href="index.php">index.php</a> et copiez le texte HTML de la balise <code>&ltfooter&gt</code> à la balise <code>&lt/footer&gt</code></a></li>
            <li><input type="checkbox"> Collez ce texte dans le fichier <a href="footer.php">footer.php</a></li>
            <li><input type="checkbox"> Revenez dans le code du fichier <a href="index.php">index.php</a> et remplacez le code HTML du pied de page par ce code : <code class="php">&lt?php require "footer.php"; ?&gt</code></li>
            <li><input type="checkbox"> Testez votre code : ouvrez le site sur votre navigateur. S'il n'y a pas d'erreur c'est que votre fonction <code class="php">require</code> a fonctionné !</li>

            <div class="info">
              <p>Vous auriez aussi pu utiliser <code class="php">&lt?php include "footer.php"; ?&gt</code> mais je vous invite à privilégier <code class="php">require</code>.
              La fonction <code class="php">include</code> est plus permissive que <code class="php">require</code>.
              Si le fichier footer.php n'existe pas, avec <code class="php">include</code> un simple warning sera levé alors qu'en utilisant <code class="php">require</code> une erreur fatale empêchera la page de s'afficher.</p>
            </div>
            <li><input type="checkbox"> Faites de même pour toutes les pages du site.</li>

            <div class="warn">
              <p>Attention, pour les pages contenues dans le répertoire recettes, pensez à changer le chemin relatif : <code class="php">&lt?php require "../footer.php"; ?&gt</code></p>
            </div>
            <div class="warn">
              <p>Attention, l'image de la flèche vers le haut ne s'affiche certainement plus pour les pages du répertoire recette !
                Le lien vers l'image étant relatif, il dépend donc de la page qui va inclure <a href="footer.php">footer.php</a> !</p>
              <p>Pour régler ce problème, modifiez le lien relatif vers l'image avec son chemin absolu.</p>
            </div>
            <div class="info">
              <p>Pour connaître le chemin absolu de votre image, commencez par regarder l'URL de votre page dans la barre d'adresse.<br>
                Pour moi, c'est "http://localhost:8888/<b>tp_php/tp_php_2</b>/tp_instructions.php", mais pour vous c'est peut-être un peu différent.</p>
              <ul>
                <li>L'adresse de mon serveur local, avec le port : http://localhost:8888
                <li>Le chemin absolu de la racine de mon projet : <b>/tp_php/tp_php_2/</b></li>
                <li>Le chemin relatif vers la page demandée : tp_instructions.php</li>
              </ul>
              <p>Chez moi, le lien vers l'image du footer <code>&ltimg src="images/up-arrow.png" alt=""&gt</code> devient <code>&ltimg src="/tp_php/tp_php_2/images/up-arrow.png" alt=""&gt</code>
            </div>
            <li><input type="checkbox"> De la même manière, utilisez la fonction php <code class="php">require</code> pour inclure <a href="nav.php">nav.php</a> à la place de la barre de navigation de chaque page.</li>
            <li><input type="checkbox"> A présent modifiez toutes les pages du site pour inclure <a href="nav.php">nav.php</a> à la place de la balise <code>&ltnav&gt</code>.</li>
            <div class="warn">
              <p>Attention, votre site n'est sûrement plus opérationnel ! Les liens dans la navigation sont relatifs, ils dépendent donc de la page qui va inclure <a href="nav.php">nav.php</a> !</p>
              <p>Pour régler ce problème, modifiez les liens de votre barre de navigation avec les chemins absolus des pages php cibles.</p>
            </div>
          </ol>

          <h3 id="partie_3">Partie 3 : Utiliser une variable</h3>
            <img class="illustration_tp"
                  src="images/box.png"
                  alt="Illustration d'une boîte ouverte"/>
            <ol>
              <li><input type="checkbox"> Créez un fichier <a href="head.php">head.php</a> à la racine de votre projet.</li>
              <li><input type="checkbox"> Faites un copier/coller des 18 premières lignes de <a href="index.php">index.php</a> dans le fichier <a href="head.php">head.php</a>.</li>
              <li><input type="checkbox"> Dans le fichier <a href="index.php">index.php</a> supprimez les 18 premières lignes et remplacez-les par l'appel à la fonction php <code class="php">require</code> pour inclure <a href="head.php">head.php</a>.</li>
              <div class="warn">
                <p>Attention, votre site n'est sûrement plus opérationnel !<br>Il est probable que vous ayez de nouveau à gérer des problématiques liées aux chemins relatifs et absolu. A vous de jouer !</p>
              </div>
              <div class="info">
                <p>
                   Avez-vous remarqué que les 18 premières lignes de chaque fichier sont (presque) tout le temps identique ? Nous allons voir comment conserver leur titre unique tout en conservant l'appel à la fonction <code class="php">require</code>.
                </p>
              </div>
              <li><input type="checkbox"> Avant l'appel à la fonction <code>require</code> pour inclure <a href="head.php">head.php</a> nous allons définir une variable nommée <code class="php">$page_title</code> contenant le titre de la page.
                  <p>
                    <code class="php">&lt?php<br>
                      $page_title = "Accueil - Mes recettes";<br>
                      require "head.php";<br>
                    ?&gt</code>
                  </p>
              </li>
              <li><input type="checkbox"> Dans le fichier <a href="head.php">head.php</a>, modifiez la ligne de la balise <code class="php">&lttitle&gt</code> de cette manière :
                <p>
                  <code class="php">&lttitle&gt&lt?php echo $page_title ?&gt&lt/title&gt</code>
                </p>
              </li>
              <li><input type="checkbox"> Faites de même pour toutes les pages du site afin qu'elles retrouvent leur titre d'origine.</li>

            </ol>

          <h3 id="partie_4">Partie 4 : Envoyer des informations via l'URL</h3>
            <img class="illustration_tp"
                  src="images/give.png"
                  alt="Illustration d'un cadeau"/>
            <ol>
              <li><input type="checkbox"> Cliquez sur "Contact" dans le menu du site Mes recettes.</li>
              <li><input type="checkbox"> Dans la barre d'adresse vous pouvez voir l'URL de la page. Nous allons la modifier, à la fin, après contact.php, ajouter <code>?prenom=Flavie</code> en remplaçant Flavie par votre propre prénom.</li>
              <div class="info">
                <p>
                  L'URL de ma page étant <code>http://localhost:8888/tp_php/tp_php_2/contact.php</code>, je la modifie pour obtenir <code>http://localhost:8888/tp_php/tp_php_2/contact.php?prenom=Flavie</code>.
                </p>
              </div>
              <li><input type="checkbox"> Visualisez le changement sur la page contact lorsque vous avez ajouté votre nom dans l'URL comme indiqué à l'étape précédente.</li>
              <div class="info">
                <p>
                  Lorsque votre navigateur souhaite accéder à une page web (ou toute autre ressource), une requête HTTP est effectuée, dans la plupart du temps avec la méthode GET (demander une ressource au serveur).
                </p>
                <p>
                  En ajoutant <code>?prenom=VotrePrenom</code> à l'URL vous venez d'utiliser un paramètre (ici prenom) avec votre requête HTTP de type GET en modifiant directement l'URL.
                </p>
              </div>
            </ol>

            <h3 id="partie_5">Partie 5 : Apprenti cuisto</h3>
              <img class="illustration_tp"
                    src="images/cooking.png"
                    alt="Dessin d'un cuisinier"/>
            <ol>
              <li><input type="checkbox"> Choisissez votre recette préférée et ajoutez-la à ce site !</li>
              <div class="info">
                <p>
                  Vous devrez bien sûr utiliser require, créer un nouveau fichier, indiquer les ingrédients dans la barre latérale, ajouter une image, modifier la barre de navigation...
                </p>
              </div>
                <li><input type="checkbox"> Faites un screenshot de votre merveilleuse recette et partagez-la avec la classe !</li>
            </ol>
      </article>

      <aside class="sommaire">
        <h2>Sommaire</h2>
        <ol>
          <li><a href="#partie_1">Partie 1 : Prise en main du site</a></li>
          <li><a href="#partie_2">Partie 2 : Un code modulaire</a></li>
          <li><a href="#partie_3">Partie 3 : Utiliser une variable</a></li>
          <li><a href="#partie_4">Partie 4 : Envoyer des informations via l'URL</a></li>
          <li><a href="#partie_5">Partie 5 : Apprenti cuisto</a></li>
        </ol>
      </aside>
    </main>

    <footer>
      <p>Site créé dans le cadre d'un cours de PHP à l'IPSSI. <a href="#"><img src="images/up-arrow.png" alt=""/></a></p>
    </footer>

  </body>
</html>
